//======================================
// CozPlayerEditMutator
//======================================
class CozPlayerEditMutator extends Mutator config(DeusEx);

#exec TEXTURE IMPORT NAME=CRPGHELP1 FILE=..\RPGMasterTest\Textures\CRPG_Halp_1.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=CRPGHELP2 FILE=..\RPGMasterTest\Textures\CRPG_Halp_2.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=CRPGHELP3 FILE=..\RPGMasterTest\Textures\CRPG_Halp_3.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=CRPGHELP4 FILE=..\RPGMasterTest\Textures\CRPG_Halp_4.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=CRPGHELP5 FILE=..\RPGMasterTest\Textures\CRPG_Halp_5.bmp GROUP=Skins

Var NanoKeyRing NKR;
Var DeusExPlayer AptHolder[20]; //Note: Starts at 1 (never 0) and goes to 20 (for() starts from 1 and ++s)
//===========================
// 1 - 6 = Hotel in city
// 7 - 10 = Chinatown apt
// 10 + = Houses?
//===========================
Var int RoomKeyVar[20]; //Cozmo: Obsolete!
Var PoliceCrimeMon PCMM;
Var AlliancesHandler AH;
var CozATM2 pATM;
//===========================
// Hitlist vars
//===========================
Var DeusExPlayer Victim[10];
Var DeusExPlayer ClientH[10];
Var String BulletinContents[10];
Var Int PriceOnHead[10];
var int paidto[10];

function Mutate (String S, PlayerPawn Player)
{
	local int i; //no 5 of these are not necessary, but cba to find out what's wrong with old code
	local int k;
	local int q;
	local int l;
	local int z;

	if(mid(S, 0, 10) ~= "hit price ")
	{
		for(i=1; i<10; i++)
		{
			if(DeusExPlayer(Player) == ClientH[i])
			{
				PriceOnHead[i] = int(mid(S, 10));
				DeusExPlayer(Player).ClientMessage("|p2Hit price now set to "$PriceOnHead[i]$" credits.");
				return;
			}
		}

		for(k=1; k<10; k++)
		{
			if(ClientH[k] == None)
			{
				ClientH[k] = DeusExPlayer(Player);
				PriceOnHead[k] = int(mid(S, 10));
				DeusExPlayer(Player).ClientMessage("|p2Hit price now set to "$PriceOnHead[k]$" credits.");
				return;
			}
		}
	}

	if(mid(S, 0, 12) ~= "hit comment ")
	{
		for(q=1; q<10; q++)
		{
			if(DeusExPlayer(Player) == ClientH[q])
			{
				BulletinContents[q] = mid(S, 12);
				DeusExPlayer(Player).ClientMessage("|p2Hit comment now set to --- '"$BulletinContents[q]$"'");
				return;
			}
		}

		for(l=1; l<10; l++)
		{
			if(ClientH[l] == None)
			{
				ClientH[l] = DeusExPlayer(Player);
				BulletinContents[l] = mid(S, 12);
				DeusExPlayer(Player).ClientMessage("|p2Hit comment now set to "$BulletinContents[l]);
				return;
			}
		}
	}

	if(S == "hit clear")
	{
		for(z=1; z<10; z++)
		{
			if(ClientH[z] == DeusExPlayer(Player))
			{
				DeusExPlayer(Player).ClientMessage("|p2Hit on "$Victim[z].PlayerReplicationInfo.PlayerName$" has been cancelled, and your "$paidto[z]$" credits have been taken back.");
				Victim[z] = None;
				DeusExPlayer(Player).Credits += paidto[z];
				paidto[z] = 0;
			}
		}	
	}
}

function PostBeginPlay()
{
	local PoliceCrimeMon PCM;
	local AlliancesHandler AHH;
	local CozATM2 CATM;

	Super.BeginPlay();

	foreach AllActors(class'AlliancesHandler',AHH)
	{
		AH = AHH;
	}

	foreach AllActors(class'PoliceCrimeMon',PCM)
	{
		PCMM = PCM;
	}

	if(pATM == None)
	{
		foreach AllActors(class'CozATM2',CATM)
		{
			if(CATM.Tag == 'MasterATM')
			{
				pATM = CATM;
			}
		}
	}

	//SetTimer(5.0, true);

	Level.Game.BaseMutator.AddMutator(Self);
}

function BeginPlay()
{
	local PoliceCrimeMon PCM;
	local AlliancesHandler AHH;
	local CozATM2 CATM;

	Super.BeginPlay();

	foreach AllActors(class'AlliancesHandler',AHH)
	{
		AH = AHH;
	}

	foreach AllActors(class'PoliceCrimeMon',PCM)
	{
		PCM = PCMM;
	}

	if(pATM == None)
	{
		foreach AllActors(class'CozATM2',CATM)
		{
			if(CATM.Tag == 'MasterATM')
			{
				pATM = CATM;
			}
		}
	}

	//SetTimer(5.0, true);
}

function ScoreKill(Pawn Killer, Pawn Other)
{
	local DeusExPlayer OP;
	local DeusExPlayer KP;
	local int i;
	local int k;

	If(Other.IsA('DeusExPlayer'))
	{
		OP = DeusExPlayer(Other);

		//OP.bBeltIsMPInventory = True; //Only worked in LAN

		if(Killer.IsA('DeusExPlayer'))
		{
			KP = DeusExPlayer(Killer);

			if(OP.Credits > 0)
			{
				KP.Credits += OP.Credits;
				KP.ClientMessage("You took "$OP.Credits$" off of"@OP.PlayerReplicationInfo.PlayerName@"'s corpse.");
			}
			else
			{
				KP.ClientMessage("You searched"@OP.PlayerReplicationInfo.PlayerName@"'s corpse but found no money.");
			}

			for (i=1; i<21; i++)
			{
				if(KP == PCMM.Criminal[i])
				{
					if(PCMM.CriminalLevel[i] >= 1)
					{
						PCMM.CriminalLevel[i] += 15;
						//KP.Alliance = 'Criminal'; //Cozmo: If it somehow isn't already, like I found in beta sometimes
						AH.HandleAlliance(DeusExPlayer(Killer), 'Criminal');
						KP.ClientMessage("|p2Current criminal level: "$PCMM.CriminalLevel[i]);
						return;
					}
				}
			}

			for (k=1; k<21; k++)
			{
				if(PCMM.Criminal[k] == None)
				{
					PCMM.Criminal[k] = KP;
					PCMM.CriminalLevel[k] += 15;
					KP.ClientMessage("|p2The police are angry with you. Current criminal level: 15");
					BroadcastMessage("|P2"$KP.PlayerReplicationInfo.PlayerName$" is now wanted by the police.");
					//KP.Alliance = 'Criminal';
					AH.HandleAlliance(DeusExPlayer(Killer), 'Criminal');
					return;
				}
			}
		}
	}
}

function ModifyPlayer(Pawn Other)
{
	local int x;
	local int k;
	local int i;
	local int m;
	local PoliceJailCell Dest;
	local Human P;
	local CozCreditCard ccc;
	local AptRespawn TELE;

	if(Other.IsA('Human'))
	{
		P = Human(Other);
	}
	else
	{
		return;
	}

	if((P.Mesh == LodMesh'DeusExCharacters.mp_Jumpsuit') && (P.MultiSkins[3] != Texture'DeusExCharacters.Skins.Male1Tex0'))
	{
		P.Mesh = LodMesh'DeusExCharacters.mp_Jumpsuit';

		P.MultiSkins[0]=Texture'DeusExItems.Skins.PinkMaskTex';
		P.MultiSkins[1]=Texture'DeusExCharacters.Skins.Male2Tex2';
		P.MultiSkins[2]=Texture'DeusExCharacters.Skins.Male3Tex1';
		P.MultiSkins[3]=Texture'DeusExCharacters.Skins.Male1Tex0';
		P.MultiSkins[4]=Texture'DeusExItems.Skins.PinkMaskTex';
		P.MultiSkins[5]=Texture'DeusExItems.Skins.PinkMaskTex';// Was grey
		P.MultiSkins[6]=Texture'DeusExItems.Skins.PinkMaskTex';
		P.MultiSkins[7]=Texture'DeusExItems.Skins.PinkMaskTex';

		//P.MultiSkins[0]=None;
		//P.MultiSkins[1]=Texture'DeusExCharacters.Skins.Male2Tex2';
		//P.MultiSkins[2]=Texture'DeusExCharacters.Skins.Male3Tex1';
		//P.MultiSkins[3]=Texture'DeusExCharacters.Skins.Male1Tex0';
		//P.MultiSkins[4]=None;
		//P.MultiSkins[5]=None;
		//P.MultiSkins[6]=None;
		//P.MultiSkins[7]=None;
	}
	else if((P.Mesh == LodMesh'DeusExCharacters.GM_Suit') && (P.MultiSkins[0] != Texture'DeusExCharacters.Skins.Male1Tex0'))
	{
		P.Mesh = LodMesh'DeusExCharacters.mp_Jumpsuit';

		P.MultiSkins[0]=Texture'DeusExItems.Skins.PinkMaskTex';
		P.MultiSkins[1]=Texture'DeusExCharacters.Skins.Male2Tex2';
		P.MultiSkins[2]=Texture'DeusExCharacters.Skins.Male3Tex1';
		P.MultiSkins[3]=Texture'DeusExCharacters.Skins.Male1Tex0';
		P.MultiSkins[4]=Texture'DeusExItems.Skins.PinkMaskTex';
		P.MultiSkins[5]=Texture'DeusExItems.Skins.PinkMaskTex';// Was grey
		P.MultiSkins[6]=Texture'DeusExItems.Skins.PinkMaskTex';
		P.MultiSkins[7]=Texture'DeusExItems.Skins.PinkMaskTex';

		//P.MultiSkins[0]=None;
		//P.MultiSkins[1]=Texture'DeusExCharacters.Skins.Male2Tex2';
		//P.MultiSkins[2]=Texture'DeusExCharacters.Skins.Male3Tex1';
		//P.MultiSkins[3]=Texture'DeusExCharacters.Skins.Male1Tex0';
		//P.MultiSkins[4]=None;
		//P.MultiSkins[5]=None;
		//P.MultiSkins[6]=None;
		//P.MultiSkins[7]=None;
	}
	else if((P.Mesh != LodMesh'DeusExCharacters.mp_Jumpsuit') && (P.Mesh != LodMesh'DeusExCharacters.GM_Suit')) //I think it's just trench
	{
		P.Mesh = LodMesh'DeusExCharacters.mp_Jumpsuit';

		P.MultiSkins[0]=Texture'DeusExItems.Skins.PinkMaskTex';
		P.MultiSkins[1]=Texture'DeusExCharacters.Skins.Male2Tex2';
		P.MultiSkins[2]=Texture'DeusExCharacters.Skins.Male3Tex1';
		P.MultiSkins[3]=Texture'DeusExCharacters.Skins.Male1Tex0';
		P.MultiSkins[4]=Texture'DeusExItems.Skins.PinkMaskTex';
		P.MultiSkins[5]=Texture'DeusExItems.Skins.PinkMaskTex';// Was grey
		P.MultiSkins[6]=Texture'DeusExItems.Skins.PinkMaskTex';
		P.MultiSkins[7]=Texture'DeusExItems.Skins.PinkMaskTex';
	}

	for (i=1; i<20; i++)
	{
		if(P == PCMM.Criminal[i])
		{
			PCMM.CriminalLevel[i] = 0;
			PCMM.Criminal[i] = None;
		}
	}

	if(P.Alliance == 'Criminal')
	{
		P.Alliance = 'Player';
	}

	ccc = Spawn(class'CozCreditCard');
	ccc.Frob(P,None);

	if(ccc.Owner == None)
	{
		ccc.Destroy();
	}

	P.Credits = 200;

	for (x=1; x<20; x++) //If they already have some money in the bank, don't give them credits on respawn
	{
		if(pATM.AccountOwner[x] == P)
		{
			if(pATM.AccountMoney[x] > 150)
			{
				P.Credits = 15; //Enough to buy a snack or two...
			}
		}
	}

	P.Fatness = 128;
	P.Texture = Texture'DeusExItems.Skins.PinkMaskTex';
	P.mpGroundSpeed = 250;
	DeusExRootWindow(P.RootWindow).HUD.AugDisplay.VisionLevel = 4;

	foreach AllActors(class'CozCreditCard',ccc)
	{
		if(ccc.owner==none) ccc.Destroy();
	}

	//P.bBeltIsMPInventory = False; //uh...

	for (k=1; k<20; k++)
	{	
		if(P == AptHolder[k])
		{
			foreach AllActors(class'AptRespawn',TELE)
			{
				if(TELE.RoomOwner == P)
				{
					P.SetLocation(TELE.Location);
				}
			}
		}
	}

	foreach AllActors(Class'PoliceJailCell', Dest)
	{
		if(Dest.Prisoner == P)
		{
			P.ClientMessage("|p2You will respawn here until your sentence is over. Get a player to break you out or do your time.");
			P.SetLocation(DEST.Location);
		}
	}
}

defaultproperties
{
}
